package com.roco.settle.api.request.order.payment;

import com.roco.settle.api.enums.SettlePaymentApplyTypeEnum;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;


/**
 * @author djt
 * @date 2020/02/27
 */
@Setter
@Getter
public class SupplierPaymentApplySaveReq implements Serializable {

    /**
     * 业务主体code
     */
    @NotBlank
    private String bizSubjectCode;

    /**
     * 业务主体简称
     */
    @NotBlank
    private String bizSubjectSimplerName;
    /**
     * 供应商code
     */
    @NotBlank
    private String supplierCode;

    /**
     * 供应商名称
     */
    @NotBlank
    private String  supplierSimpleName;
    /**
     * 事项申请单
     */
    @NotBlank
    private String matterNo;

    /**
     * 对私转账申请单号
     */
    @NotBlank
    private String transferApplyNo;

    /**
     * 支付总金额(元)
     */
    @NotNull
    private BigDecimal amount;

    /**
     * 支付笔数
     */
    @NotNull
    private Integer cnt;
}
