package com.roco.settle.api.service.enterprisesettle;

import com.roco.settle.api.entity.SettleEnterpriseServiceApplyItem;
import com.roco.settle.api.entity.enterprisesettle.SettleEnterpriseOilCardApply;
import com.roco.settle.api.entity.enterprisetansfer.SettleEnterpriseTransferApply;
import com.roco.settle.api.entity.enterprisetansfer.SettleEnterpriseTransferApplyLog;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.enterprisesettle.EnterpriseOilCardApplyQueryReq;
import com.roco.settle.api.request.enterprisetansfer.EnterpriseTransferApplyFileReq;
import com.roco.settle.api.request.enterprisetansfer.EnterpriseTransferApplyReq;
import com.roco.settle.api.request.enterprisetansfer.EnterpriseTransferOperateReq;
import com.roco.settle.api.request.enterprisetansfer.EnterpriseTransferQueryReq;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;
import com.roco.settle.api.response.enterprisetansfer.EnterpriseTransferFileRes;

/**
 * 业务基点->油卡结算申请
 * @author zhangmin
 * @create 2020/2/24 1:39 下午
 */
public interface SettleEnterpriseOilCardApplyService {

    /**
     * 分页查询 油卡结算申请单列表
     * @param request
     * @return
     */
    public CommonQueryPageResponse<SettleEnterpriseOilCardApply> searchPage(CommonQueryPageRequest<EnterpriseOilCardApplyQueryReq> request);


    /**
     * 对公转账清单上传
     *
     * @param request
     * @return
     */
    CommonResponse<EnterpriseTransferFileRes> uploadFile(CommonRequest<EnterpriseTransferApplyFileReq> request);

    /**
     * 对公转账申请
     *
     * @param request
     * @return
     */
    CommonResponse<String> apply(CommonRequest<EnterpriseTransferApplyReq> request);

    /**
     * 操作申请单
     *
     * @param request
     * @return
     */
    CommonResponse<Boolean> operate(CommonRequest<EnterpriseTransferOperateReq> request);


    /**
     * 详情
     * @param request
     * @return
     */
    CommonResponse<SettleEnterpriseTransferApply> detail(CommonRequest<EnterpriseTransferQueryReq> request);


    /**
     * 日志查询
     * @param request
     * @return
     */
    CommonQueryPageResponse<SettleEnterpriseTransferApplyLog> log(CommonQueryPageRequest<EnterpriseTransferQueryReq> request);


    /**
     * 查询清单
     * @param request
     * @return
     */
    CommonQueryPageResponse<SettleEnterpriseServiceApplyItem> itemPage(CommonQueryPageRequest<EnterpriseTransferQueryReq> request);



}
