package com.roco.settle.api.service.order.payment;

import com.roco.settle.api.entity.order.payment.SupplierPaymentApply;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.order.payment.*;
import com.roco.settle.api.request.settlepaymentapply.SettlePaymentApplyFinancialPaymentReq;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;

/**
 * 供应商支付订单服务接口
 * @author djt
 */
public interface SupplierPaymentApplyService {

    /**
     * 新增数据
     *
     * @param request 实例对象
     * @return 实例对象
     */
    CommonResponse<SupplierPaymentApply> save(CommonRequest<SupplierPaymentApplySaveReq> request);


    /**
     * 分页查询
     * @param pageRequest
     * @return
     */
    CommonQueryPageResponse<SupplierPaymentApply> page(CommonQueryPageRequest<SupplierPaymentApplyPageReq> pageRequest);


    /**
     * 明细
     *
     * @param request
     * @return
     */
    CommonResponse<SupplierPaymentApply> detail(CommonRequest<SupplierPaymentApplyDetailReq> request);


    /**
     *
     * 状态更改: 更新状态
     *
     * @param request
     * @return
     */
    CommonResponse<Boolean> updateStatus(CommonRequest<SupplierPaymentApplyStatusReq> request);



    /**
     *
     * 上传支付凭证
     *
     * @param request
     * @return
     */
    CommonResponse<Boolean> financialPaymentSettlePaymentApply(CommonRequest<SupplierPaymentApplyFinancialPaymentReq > request);
}
