package com.roco.settle.api.request.order;

import com.roco.settle.api.enums.order.OrderOperationTypeEnum;
import com.roco.settle.api.enums.order.SettleMatterType;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.io.Serializable;

/**
 * @author dongjuntong
 * @create 2020/2/6 15:35
 */
@Data
public class SupplierInvoiceOrderUpdateStatusReq implements Serializable {


    /**
     * 供应商开票订单号
     */
    @NotNull(message = "供应商开票订单号不能为空")
    private String orderCode;

    /**
     * 发票操作
     */
    @NotNull(message = "操作类型不能为空")
    private OrderOperationTypeEnum operationType;

    /**
     * 结算事项申请单号
     */
    @NotNull(message = "结算事项申请单号不能为空")
    private String applyNo;


   /**
     * 结算事项类型
     */
    @NotNull(message = "结算事项类型不能为空")
    private SettleMatterType  settleMatterType;

}
