package com.roco.settle.api.response.settlecapital;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.enums.IsEnum;
import com.roco.settle.api.enums.StatusEnum;
import com.roco.settle.api.util.DateUtil;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.Column;
import javax.persistence.Transient;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/2/5 10:16</dd>
 * <dd>@author：zhanghs</dd>
 * </dl>
 */
@Getter
@Setter
@ToString
public class SettleCapitalAccountDetailResp implements Serializable {

    private Long id;
    /**
     * 账户编码
     */
    private String accountCode;

    /**
     * 机构编码
     */
    private String enterpriseCode;

    /**
     * 机构简称
     */
    private String enterpriseSimpleName;

    /**
     * 机构名称
     */
    private String enterpriseName;

    /**
     * 机构简称拼音
     */
    private String enterpriseNamePinyin;

    /**
     * 机构简称首字母
     */
    private String enterpriseNameFirtPinyin;

    /**
     * 人保机构号
     */
    private String piccOrgCode;

    /**
     * 是否人保机构号
     */
    private Integer isPicc;

    /**
     * 业务汇总点简称
     */
    private String enterprisePSimpleName;

    /**
     * 业务主体编码
     */
    private String bizSubjectCode;

    @Transient
    private String bizSubjectSimpleName;

    /**
     * 存入总金额
     */
    private BigDecimal totalAmount;

    /**
     * 账户余额
     */
    private BigDecimal canAmount;

    /**
     * 已结算总额
     */
    private BigDecimal settledAmount;

    /**
     * 未结算总额
     */
    private BigDecimal unsettledAmount;

    /**
     * 未结算订单数
     */
    private Integer unsettledOrderCnt;

    /**
     * 已结算订单数
     */
    private Integer settledOrderCnt;

    /**
     * 存款次数
     */
    private Integer depositCnt;

    /**
     * 结算次数
     */
    private Integer settledCnt;

    /**
     * 业务主体是否垫资
     */
    @Column(name = "debt")
    private IsEnum debt;

    /**
     * 垫资金额
     */
    private BigDecimal debtAmount;

    /**
     * 账户状态
     */
    @Column(name = "status")
    private StatusEnum status;

    /**
     * 版本号
     */
    private Integer revision;


    /**
     * 创建人id
     */
    private Long createUser;

    /**
     * 创建人姓名
     */
    private String createUsername;

    /**
     * 创建日期
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate createDate;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

    /**
     * 更新人id
     */
    private Long updateUser;

    /**
     * 更新人姓名
     */
    private String updateUsername;

    /**
     * 最后统计日期
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate lastStatistcDate;
    /**
     * 最后统计时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime lastStatisticDateTime;

    /**
     * 业务费用发生额
     */
    private BigDecimal useAmount;

}