package com.roco.settle.api.entity.privatetransfer;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import com.roco.settle.api.enums.privatetransfer.SettlePrivateAttachApplyItemStatusEnum;
import lombok.Data;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;


/**
 * 对私转账-账户转账明细(SettlePrivateAttachApplyItem)实体类
 *
 * @author hsf
 * @since 2020-02-29 11:08:42
 */
@Data
@Table(name = "settle_private_attach_apply_item")
public class SettlePrivateAttachApplyItem implements Serializable {

   
    @Id
    private Long id;

    /**
     * 申请单编码(settle_private_attach_apply.apply_no)  
     */
    private String applyNo;

    /**
     * 明细编码  
     */
    private String detailNo;

    /**
     * settle_private_apply.apply_no  
     */
    private String privateNo;

    /**
     * 对公账户  
     */
    private String accountType;

    /**
     * 账号  
     */
    private String account;

    /**
     * 账户名称  
     */
    private String accountName;

    /**
     * 开户银行  
     */
    private String bank;

    /**
     * 开户支行  
     */
    private String subbranch;

    /**
     * 转账金额  
     */
    private BigDecimal transferAmount;

    /**
     * 状态(UNPAID-未支付, PAID-已支付)  
     */
    @Column(name = "status")
    private SettlePrivateAttachApplyItemStatusEnum status;

    /**
     * 备注
     */
    private String remark;

    /**
     * 支付时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime paidTime;

    /**
     * 创建人  
     */
    private String createUser;

    /**
     * 创建人名称  
     */
    private String createName;

    /**
     * 创建时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 更新人  
     */
    private String updateUser;

    /**
     * 更新人名称  
     */
    private String updateName;

    /**
     * 更新时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

   

}