package com.roco.settle.api.entity.supplier;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author Andrew
 * @create 2020/2/19 11:02 上午
 */
@Data
@Table(name = "product_settlement_history")
public class ProductSettlementHistory implements Serializable {

    @Id
    private Long id;
    /**
     * 商品编码
     */
    private String productCode;
    /**
     * 企业编码
     */
    private String enterpriseCode;
    /**
     *
     * 结算模式(0进销差,1收推广服务费)
     *
     *  @see com.roco.settle.api.enums.ProductSettlementModeEnum
     */
    private Integer mode;
    /**
     * 采购价
     */
    private BigDecimal purchasePrice;
    /**
     * 中介代理服务费(Intermediary agency service fee
     */
    private BigDecimal iyasFee;
    /**
     * 保险代理服务费(Insurance agency service fee)
     */
    private BigDecimal ieasFee;
    /**
     * 销售价
     */
    private BigDecimal sellPrice;
    /**
     * 推广服务费系数(Promotion service fee ratio
     */
    private BigDecimal psfRatio;
    /**
     * 说明
     */
    private String remark;

    private Long createUser;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    private String createUsertype;

    private String createName;

    private Long updateUser;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

    private String updateUsertype;

    private String updateName;
}
