package com.roco.settle.api.request.supplier.product;

import com.roco.settle.api.request.base.BasePrimaryKeyRequest;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author Andrew
 * @create 2020/2/19 11:15 上午
 */
@Data
public class ProductUpdateReq extends BasePrimaryKeyRequest implements Serializable {

    /**
     * 名称
     */
    @NotBlank
    private String name;

    /**
     * 简称
     */
    @NotBlank
    private String simpleName;
    /**
     * 供应商编号
     */
    @NotBlank
    private String supplierNo;
    /**
     * 类目编码
     */
    @NotBlank
    private String catalogCode;
    /**
     * 品牌编码
     */
    @NotBlank
    private String brandCode;
    /**
     * 面值
     */
    private BigDecimal price;
    /**
     * 充值折扣
     */
    private BigDecimal discount;
    /**
     * 状态(1启用,0停用)
     */
    private Integer status;
    /**
     * 说明
     */
    private String remark;


}
