/*
 * Decompiled with CFR 0.152.
 */
package com.roco.settle.api.enums;

import com.roco.settle.api.entity.supplier.ProductSettlement;
import java.math.BigDecimal;

public enum ProductSettlementModeEnum {
    DIFF_SALES(0, "\u8fdb\u9500\u5dee"),
    PROMOTION_SERVICE_FEE(1, "\u6536\u63a8\u5e7f\u670d\u52a1\u8d39");

    private int code;
    private String msg;

    public static ProductSettlementModeEnum getByCode(int code) {
        for (ProductSettlementModeEnum v : ProductSettlementModeEnum.values()) {
            if (v.code != code) continue;
            return v;
        }
        return null;
    }

    private ProductSettlementModeEnum(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private void checkMode(ProductSettlementModeEnum target) {
        if (this != target) {
            throw new IllegalArgumentException("\u8be5\u7ed3\u7b97\u6a21\u5f0f\u6ca1\u6709\u6b64\u65b9\u6cd5\uff0c\u8be5\u65b9\u6cd5\u5b58\u5728[" + target.msg + "]\u6a21\u5f0f\u4e0b");
        }
    }

    public BigDecimal getPurchasePrice(ProductSettlement productSettlement) {
        this.checkMode(DIFF_SALES);
        return productSettlement.getPurchasePrice();
    }

    public BigDecimal getIyasFee(ProductSettlement productSettlement) {
        this.checkMode(DIFF_SALES);
        return productSettlement.getIyasFee();
    }

    public BigDecimal getIeasFee(ProductSettlement productSettlement) {
        this.checkMode(DIFF_SALES);
        return productSettlement.getIeasFee();
    }

    public BigDecimal getSellPrice(ProductSettlement productSettlement) {
        this.checkMode(DIFF_SALES);
        return productSettlement.getSellPrice();
    }

    public BigDecimal getPsfRatio(ProductSettlement productSettlement) {
        this.checkMode(PROMOTION_SERVICE_FEE);
        return productSettlement.getPsfRatio();
    }
}

