package com.roco.settle.api.request.supplier.supplychain;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**<p>Title:供应商 </p>
 * <p>Description:对应表名：sc_supplier  </p>
 * <p>作者：zhuzhoucheng</p>
 * <p>日期：2019-05-31 20:03:54</p>
 * <p>版本：1.0</p>
 * @author lanqian
 */
@Data
public class SupplierSaveReq implements Serializable {
	

	/**
	 * 供应商ID
	 */
	private Long supplierId;
	/**
	 * 供应商名称
	 */
	@NotBlank
	private String supplierName;
	/**
	 * 简介
	 */
	private String description;
	/**
	 * 地区编号
	 */
	private String regionNo;
	/**
	 * 省
	 */
	private String province;
	/**
	 * 市
	 */
	private String city;
	/**
	 * 区
	 */
	private String area;
    /**
     * 省
     */
    private String provinceCode;
    /**
     * 市
     */
    private String cityCode;
    /**
     * 区
     */
    private String areaCode;
	/**
	 * 详细地址
	 */
	private String address;
	/**
	 * 法人
	 */
	private String legalPerson;
	/**
	 * 营业执照编号
	 */
	private String businessLicenseNo;
	/**
	 * 营业执照图片(阿里云)
	 */
	private String businessLicenseImg;
	/**
	 * 状态
	 */
    @NotNull
	private Integer status;
	/**
	 * 联系人列表
	 */
	private List<SupplierContactsReq> contacts;

	/**
	 * 供应商类型
	 * */
    @NotBlank
	private String providerType;

	/**
	 * 服务类型
	 * */
	private String categoryCode;

	/**
	 * 服务类型
	 * */
	private String categoryName;

	/**
	 * *
	 * * 是否主体*/
    @NotBlank
	private String mainPartType;

	/**
	 * 主体编码
	 * */
	private String mainPartCode;

	/**
	 * 营业执照名称
	 * */
	private String licenseName;

	/**
	 * *
	 * * 人保车务平台门店编号*/
	private String shopCode ;

	/**
	 * 是否人保车务平台上架
	 * */
    @NotBlank
	private String isOnline;
    /**
     * 商户类型
     * */
    @NotBlank
    private String merchantTypeCode;
    /**
     * 商户类型名称
     * */
    @NotBlank
    private String merchantTypeName;

	/**
	 * 人保推修码
	 */
	private String insuranceRepairNo;

	/**
	 * 渠道列表
	 */
	private List<SupplierChannelsReq> supplierChannelsList;

	/**
	 * 渠道编码
	 */
	private String supplierNo;
}
