package com.roco.settle.api.service.order;

import com.roco.settle.api.entity.order.SupplierInvoiceOrderExpress;
import com.roco.settle.api.request.base.BasePrimaryKeyRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.order.SupplierInvoiceOrderExpressDeleteReq;
import com.roco.settle.api.request.order.SupplierInvoiceOrderExpressPageReq;
import com.roco.settle.api.request.order.SupplierInvoiceOrderExpressSaveReq;
import com.roco.settle.api.request.order.SupplierInvoiceOrderExpressUpdateReq;
import com.roco.settle.api.response.base.CommonResponse;
import com.roco.settle.api.response.order.SupplierInvoiceOrderExpressExtResp;

import java.util.List;

/**
 * 供应商开票订单寄送信息
 * @author dongjuntong
 */
public interface SupplierInvoiceOrderExpressService {




    /**
     * 保存发票寄送信息
     * @param saveRequest
     * @return
     */
    CommonResponse<Boolean> save(CommonRequest<SupplierInvoiceOrderExpressSaveReq> saveRequest);



    /**
     * 不分页查询寄送信息
     * @param pageRequest
     * @return
     */
    CommonResponse<List<SupplierInvoiceOrderExpressExtResp>> selectExpress(CommonRequest<SupplierInvoiceOrderExpressPageReq> pageRequest);


    /**
     * 删除寄送信息
     * @param request
     * @return
     */
    CommonResponse<Boolean> delete(CommonRequest<SupplierInvoiceOrderExpressDeleteReq> request);


    /**
     * 查询寄送详情
     * @param request
     * @return
     */
    CommonResponse<SupplierInvoiceOrderExpress> detail(CommonRequest<BasePrimaryKeyRequest> request);


    /**
     * 保存发票寄送信息
     * @param updateRequest
     * @return
     */
    CommonResponse<Boolean> update(CommonRequest<SupplierInvoiceOrderExpressUpdateReq> updateRequest);
}
