package com.roco.order.api.entity;

import java.time.LocalDateTime;

import com.roco.order.api.enums.OrderMqStatusEnum;
import com.roco.order.api.enums.OrderMqTypeEnum;
import lombok.Data;

import java.io.Serializable;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;


/**
 * 油卡MQ推送信息(OrderMq)实体类
 *
 * @author hsf
 * @since 2020-03-19 16:59:07
 */
@Data
@Table(name = "order_mq")
public class OrderMq implements Serializable {

   
    @Id
    private Long id;

    /**
     * 引用编号  
     */
    private String refNo;

    /**
     * 类型(ORDER_OIL_CARD-油卡订单同步,ORDER_PUBLIC-对公转账订单,ORDER_PRIVATE-对私转账订单)
     */
    private OrderMqTypeEnum type;

    private String exchange;

    private String routeKey;

    /**
     * 消息主体  
     */
    private String message;

    /**
     * 状态(INIT-初始化,SENDING-发放中,SUCCESS-成功,FAIL-失败,MANUAL-人工处理)  
     */
    private OrderMqStatusEnum status;

    /**
     * 重试次数  
     */
    private Integer tryCount;

    private String remark;

    /**
     * 创建时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 最后重试时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime lastTryTime;

    /**
     * 失败时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime failTime;

    /**
     * 成功时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime successTime;

   

}