package com.roco.settle.api.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.enums.SettleEnterpriseServiceApplyStatusEnum;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Id;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Transient;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/2/19 15:15</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Setter
@Getter
public class SettleEnterpriseServiceApply implements Serializable {
    /**
     * id
     */
    @Id
    private Integer id;

    /**
     * 申请单编码
     */
    private String applyNo;

    /**
     * 批次号
     */
    private String batchNo;

    /**
     * 业务基点编码
     */
    private String enterpriseCode;
    /**
     * 业务基点简称
     */
    private String enterpriseSimpleName;

    /**
     * 业务主体编码
     */
    private String bizSubjectCode;

    @Transient
    private String bizSubjectSimpleName;

    /**
     * 订单处理编码
     */
    private String handleOrderNo;

    /**
     * 总笔数
     */
    private Integer totalCnt;

    /**
     * 总金额
     */
    private BigDecimal totalAmount;

    /**
     * 业务基点提供附件日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone ="GMT+08:00")
    private LocalDate enterpriseProvideDate;

    /**
     * 附件名称
     */
    private String attachName;

    /**
     * 附件描述
     */
    private String remark;

    /**
     * 附件url
     */
    private String attachUrl;

    /**
     * 申请单状态
     */
    private String status;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone ="GMT+08:00")
    private LocalDateTime createTime;

    /**
     * 创建日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone ="GMT+08:00")
    private LocalDate createDate;

    /**
     * 提交时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone ="GMT+08:00")
    private LocalDateTime submitTime;

    /**
     * 提交日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone ="GMT+08:00")
    private LocalDate submitDate;

    /**
     * 取消时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone ="GMT+08:00")
    private LocalDateTime cancelTime;

    /**
     * 取消日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone ="GMT+08:00")
    private LocalDate cancelDate;

    /**
     * 处理完毕时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone ="GMT+08:00")
    private LocalDateTime finishTime;

    /**
     * 处理完毕日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone ="GMT+08:00")
    private LocalDate finishDate;

    /**
     * 版本
     */
    private Integer revision;

    /**
     * 创建人
     */
    private Integer createUser;

    /**
     * 创建人名称
     */
    private String createName;

    /**
     * 更新人
     */
    private Integer updateUser;

    /**
     * 更新人名称
     */
    private String updateName;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone ="GMT+08:00")
    private LocalDateTime updateTime;


}