package com.roco.settle.api.service.supplier;

import com.roco.settle.api.entity.supplier.SupplierChannel;
import com.roco.settle.api.request.base.BasePrimaryKeyRequest;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.supplier.channel.SupplierChannelCodeReq;
import com.roco.settle.api.request.supplier.channel.SupplierChannelPageReq;
import com.roco.settle.api.request.supplier.channel.SupplierChannelSaveReq;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;

/**
 * 供应商渠道服务接口
 * @author djt
 * @date 2020/5/20 10:50
 */
public interface SupplierChannelService {


    /**
     * 新增渠道
     * @param request
     * @return
     */
    CommonResponse<Boolean> save(CommonRequest<SupplierChannelSaveReq> request);

    /**
     * 编辑渠道
     * @param request
     * @return
     */
    CommonResponse<Boolean> edit(CommonRequest<SupplierChannelSaveReq> request);


    /**
     * 新增渠道
     * @param request
     * @return
     */
    CommonResponse<SupplierChannel> detailByCode(CommonRequest<SupplierChannelCodeReq> request);



    /**
     * 删除渠道
     * @param request
     * @return
     */
    CommonResponse<Boolean> delete(CommonRequest<BasePrimaryKeyRequest> request);


    /**
     * 分页查询供应商渠道
     * @param request
     * @return
     */
    CommonQueryPageResponse<SupplierChannel> page(CommonQueryPageRequest<SupplierChannelPageReq> request);
}
