package com.roco.settle.api.entity;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

import lombok.Data;

import java.io.Serializable;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;


/**
 * 资金账户, 结算明细(SettleAccountSettledDetail)实体类
 *
 * @author Andrew
 * @since 2020-03-04 17:19:55
 */
@Data
@Table(name = "settle_account_settled_detail")
public class SettleAccountSettledDetail implements Serializable {

   
    @Id
    private Long id;

    /**
     * 资金账户  
     */
    private String accountCode;

    /**
     * 结算类型  
     */
    private String settleType;

    /**
     * 结算金额  
     */
    private BigDecimal settleAmount;

    /**
     * 结算申请单  
     */
    private String settleApplyNo;

    /**
     * 结算申请单事项名称  
     */
    private String settleApplyItemName;

    /**
     * 基点编码  
     */
    private String enterpriseCode;

    /**
     * 业务主体编码  
     */
    private String bizSubjectCode;

    /**
     * 结算点数  
     */
    private String settlePoint;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate createDate;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    private String createUser;

    private String createName;

   

}