package com.roco.settle.api.entity.productconfig;


import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/3/23 15:43</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
@Table(name = "settle_enterprise_product_rel")
public class SettleEnterpriseProductRel implements Serializable {
    @Id
    private Integer id;

    /**
     * 机构商品配置编码
     */
    private String code;

    /**
     * 机构编码
     */
    private String enterpriseCode;

    /**
     * 机构简称
     */
    private String simpleName;

    /**
     * 商品编码
     */
    private String productCode;

    /**
     * 人保机构码
     */
    private String piccOrgCode;

    /**
     * 创建人id
     */
    private Integer createUser;

    /**
     * 创建人名称
     */
    private String createName;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新人id
     */
    private Integer updateUser;

    /**
     * 更新人名称
     */
    private String updateName;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 销售价
     */
    @Transient
    private BigDecimal sellPrice;
    /**
     * 是否默认配置
     */
    private String isDefault;


    /**
     * 默认通道产品编码
     */
    private String channelProductCode;

    /**
     * 默认通道产品名称
     */
    private String channelProductName;

}