package com.roco.settle.api.entity.supplier;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import lombok.Data;

import java.io.Serializable;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;


/**
 * 供应商服务清单申请明细(SupplierServiceApplyItem)实体类
 *
 * @author hsf
 * @since 2020-05-25 18:35:11
 */
@Data
@Table(name = "supplier_service_apply_item")
public class SupplierServiceApplyItem implements Serializable {

   
    @Id
    private Long id;

    /**
     * 申请单编码  
     */
    private String applyNo;

    /**
     * 明细编码  
     */
    private String detailNo;

    /**
     * 使用订单号  
     */
    private String useOrderNo;

    /**
     * 服务清单项编号(settle_enterprise_service_apply_item.detail_no)
     */
    private String refDetailNo;

    /**
     * 供应商编码  
     */
    private String supplierCode;

    /**
     * 供应商名称  
     */
    private String supplierSimpleName;

    /**
     * 业务主体编码  
     */
    private String bizSubjectCode;

    /**
     * 业务主体简称
     */
    private String bizSubjectSimpleName;

    /**
     * 车牌号  
     */
    private String licenseNo;

    /**
     * 服务套餐金额  
     */
    private BigDecimal servicePackageAmount;

    /**
     * 结算价金额  
     */
    private BigDecimal settlePrice;

    /**
     * 服务套餐名称  
     */
    private String servicePackageName;

    /**
     * 服务项目编码  
     */
    private String serviceItemCode;

    /**
     * 门店编码  
     */
    private String storeCode;

    /**
     * 状态  
     */
    private String status;

    /**
     * 创建人  
     */
    private Integer createUser;

    /**
     * 创建人名称  
     */
    private String createName;

    /**
     * 创建时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 更新人  
     */
    private Integer updateUser;

    /**
     * 更新人名称  
     */
    private String updateName;

    /**
     * 更新时间  
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;


    /**
     * 结算事项类型
     */
    private String matterType;

   

}