package com.roco.settle.api.enums.order;

import lombok.Getter;

/**
 * 发票性质枚举类
 * @author dongjuntong
 */
public enum OrderStatusEnum {


    /***
     *空
     */
    EMPTY("空"),
    /**
     * 待开票
     */
    WAIT_INVOICE("待开票"),


    /**
     * 已开票
     */
    INVOICED("已开票"),


    /**
     * 财务已收到发票
     */
    RECEIVED("财务已收到发票"),


    /**
     * 取消
     */
    CANCEL("取消");


    @Getter
    private String label;


    OrderStatusEnum(String label){
        this.label=label;
    }
}
