package com.roco.settle.api.request.order.payment;

import com.roco.settle.api.enums.order.payment.PaymentOrderOperationTypeEnum;
import com.roco.settle.api.request.base.FileRes;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author djt
 *
 */
@Data
public class SupplierPaymentApplyFinancialPaymentReq implements Serializable {
    /**
     * 申请单号
     */
    @NotBlank(message = "支付订单号不能为空")
    private String applyNo;
    /**
     * 文件
     */
    private List<FileRes> reses;

    /**
     *删除的附件id
     */
   private List<Long>  deletedFileIds;
    /**
     * 订单状态
     */
    @NotNull(message ="操作类型不能为空")
    private PaymentOrderOperationTypeEnum operationType;
    /**
     * 备注
     */
    private String remark;
}
