package com.roco.settle.api.request.supplier.channel;

import lombok.Data;

import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 供应商渠道保存请求
 * @author djt
 * @date 2020/5/20 10:51
 */
@Data
public class SupplierChannelSaveReq implements Serializable {


        /**
         * 渠道编号
         */
        private String code;

        /**
         * 供应商编号
         */
        @NotBlank(message ="供应商编号不能为空")
        @Size(max = 64,message = "供应商编号不能超过64个字符")
        private String supplierCode;

        /**
         *  渠道名称
         */
        @NotBlank(message ="渠道名称不能为空")
        @Size(max = 64,message = "渠道名称不能超过64个字符")
        private String channelName;

        /**
         * 渠道摘要
         */
        @NotBlank(message = "渠道摘要不能为空")
        @Size(max = 64,message = "渠道摘要不能超过64个字符")
        private String channelBrief;

        /**
         *  备注
         */
        @Size(max = 200,message = "备注不能超过200个字符")
        private String remark;

        /**
         * 备付金账户编号
         */
        @NotBlank(message = "备付金账户编号不能为空")
        @Size(max = 64,message = "备付金账户编号不能超过64个字符")
        private String  depositAccountCode;

        /**
         * 备付金账户名称
         */
        @NotBlank(message = "备付金账户名称不能为空")
        @Size(max = 128,message = "备付金账户名称不能超过128个字符")
        private String  depositAccountName;

        /**
         * 状态
         */
        private Integer status;

        /**
         * 单笔限额
         */
        @DecimalMax(value = "9999999999.99",message = "超出最大限额")
        @DecimalMin(value = "0.01",message = "限额大于0")
        private BigDecimal limitAmount;

}
