package com.roco.order.api.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.io.Serializable;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;
import lombok.NoArgsConstructor;


/**
 * 对公转账订单(OrderPublic)实体类
 *
 * @author hsf
 * @since 2020-03-19 19:48:39
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Table(name = "order_public")
public class OrderPublic implements Serializable {

   
    @Id
    private Long id;

    /**
     * 事项编号(settle_enterprise_transfer_apply.apply_no)  
     */
    private String itemNo;

    /**
     * 事项名(settle_enterprise_transfer_apply. item_name)  
     */
    private String itemName;

    /**
     * 业务主体结算事项申请单号(settle_enterprise_transfer_handle_apply.transfer_apply_code)  
     */
    private String settleOrderNo;

    /**
     * 业务主体结算事项名称  
     */
    private String settleOrderName;

    /**
     * 业务基点结算事项申请单号(settle_enterprise_base_point_apply.apply_no)  
     */
    private String basePointOrderNo;

    /**
     * 业务基点结算事项名称  
     */
    private String basePointOrderName;

    /**
     * 业务主体编号  
     */
    private String bizSubjectCode;

    /**
     * 业务主体简称  
     */
    private String bizSubjectSimpleName;

    /**
     * 业务基点编码  
     */
    private String enterpriseCode;

    /**
     * 业务基点简称  
     */
    private String enterpriseSimpleName;

    /**
     * 人保机构号  
     */
    private String piccOrgCode;

    /**
     * 供应商编码  
     */
    private String supplierCode;

    /**
     * 供应商名称  
     */
    private String supplierName;

    /**
     * 供应商营业执照名称  
     */
    private String supplierLicenseName;

    /**
     * 供应商账户类型  
     */
    private String supplierAccountType;

    /**
     * 供应商账户名称  
     */
    private String supplierAccountName;

    /**
     * 供应商收款账号  
     */
    private String supplierAccountNo;

    /**
     * 供应商开户银行  
     */
    private String supplierBank;

    /**
     * 供应商开户支行  
     */
    private String supplierSubbranch;

    /**
     * 供应商银行账号  
     */
    private String supplierAccount;

    /**
     * 供应商账户别名  supplier_account_alias
     */
    private String supplierAccountAlias;

    /**
     * 资金账户编码  
     */
    private String ledgerFundsNo;

    /**
     * 销售价(settle_enterprise_base_point_apply.total_settle_amount)  
     */
    private BigDecimal sellPrice;

    /**
     * 销售点数  
     */
    private BigDecimal sellPoint;

    /**
     * 客户到账价格(settle_enterprise_base_point_apply.total_package_amount)  
     */
    private BigDecimal arrivePrice;

    /**
     * 状态  
     */
    private String status;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

   

}