package com.roco.settle.api.entity.enterprise.transaction;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.enums.enterprise.transaction.ToBusinessTransactionOperationEnum;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/7/2 14:49</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
@Table(name = "settle_enterprise_to_business_transaction_operation")
public class SettleEnterpriseToBusinessTransactionOperation implements Serializable {
    /**
     * 主键
     */
    @Id
    private Long id;

    /**
     * settle_enterprise_to_business_transaction.code
     */
    private String code;

    /**
     * 操作类型
     * CREATE:提交
     * CONFIRM:确认
     * PROCESS:完成处理确认
     * SETTLE:完成结算确认
     * INVALID:作废
     */
    @Column(name = "operate_type")
    private ToBusinessTransactionOperationEnum operateType;

    /**
     * 操作名称
     */
    private String operateName;

    /**
     * 操作说明
     */
    private String remark;

    /**
     * 操作时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 操作人
     */
    private Long createUser;

    /**
     * 操作人姓名
     */
    private String createName;

    /**
     * 操作人类型
     */
    private String createUsertype;

    /**
     * 逻辑删除（0：未删除，1：已删除）
     */
    private Boolean deleted;

}