package com.roco.settle.api.entity.privatetransfer;

import java.time.LocalDateTime;

import lombok.Data;

import java.io.Serializable;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;


/**
 * 对私转账操作日志(SettlePrivateLog)实体类
 *
 * @author hsf
 * @since 2020-02-28 16:48:04
 */
@Data
@Table(name = "settle_private_log")
public class SettlePrivateLog implements Serializable {

   
    @Id
    private Long id;

    /**
     * 申请单号(settle_private_transfer_handle_apply.apply_no)  
     */
    private String applyNo;

    /**
     * 操作之前的状态  
     */
    private String beforeStatus;

    /**
     * 操作备注  
     */
    private String operationDesc;

    /**
     * 操作类型  
     */
    private String operationType;

    /**
     * 操作之后的状态  
     */
    private String afterStatus;

    private String createUser;

    private String createName;

    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

   

}