package com.roco.settle.api.request.invoice;

import com.roco.settle.api.enums.invoice.InvoiceOperationTypeEnum;
import com.roco.settle.api.request.base.FileRes;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author djt
 */
@Data
public class InvoiceFileSaveReq  implements Serializable {
    /**
     * 发票申请单号
     */
    @NotBlank
    private String applyNo;

    /**
     * 发票操作类型
     */
    @NotNull
    private InvoiceOperationTypeEnum operType;

    /**
     * 发票附件
     */
    private List<FileRes> fileRes;
}
