package com.roco.settle.api.service.supplier;

import com.roco.settle.api.entity.supplier.SupplierApiConfig;
import com.roco.settle.api.request.base.BasePrimaryKeyRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.supplier.supplychain.apiconfig.SupplierApiConfigReq;
import com.roco.settle.api.request.supplier.supplychain.apiconfig.SupplierApiConfigSaveReq;
import com.roco.settle.api.response.base.CommonResponse;

/**
 * @author lanqian
 */
public interface SupplierApiConfigService {

    /**
     * 查询单条记录
     * @param request
     * @return
     */
    CommonResponse<SupplierApiConfig> get(CommonRequest<BasePrimaryKeyRequest> request);
    /**
     * 保存
     * @param request
     * @return
     */
    CommonResponse<Boolean> save(CommonRequest<SupplierApiConfigSaveReq> request);
    /**
     * 更新
     * @param request
     * @return
     */
    CommonResponse<Boolean> update(CommonRequest<SupplierApiConfigSaveReq> request);
    /**
     * 更新和新增统一接口
     * @param request
     * @return
     */
    CommonResponse<Boolean> saveOrUpdate(CommonRequest<SupplierApiConfigSaveReq> request);
    /**
     * 删除
     * @param request
     * @return
     */
    CommonResponse<Boolean> deleteById(CommonRequest<BasePrimaryKeyRequest> request);
    

    /**
     * 根据供应商supplierNo
     * 获取供应商默认的API参数配置信息
     * @param request
     * @return
     * */
    CommonResponse<SupplierApiConfig> getBySupplierNo(CommonRequest<SupplierApiConfigReq> request);
    

}
