package com.roco.settle.api.service.supplier;

import com.roco.settle.api.entity.supplier.SupplierServiceApply;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.supplier.serviceapply.SupplierServiceApplyReq;
import com.roco.settle.api.request.supplier.serviceapply.SupplierServiceApplySaveReq;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;
import com.roco.settle.api.response.settleserviceapplydetail.SettleEnterpriseServiceItemError;
import com.roco.settle.api.response.supplier.serviceapply.SupplierServiceItemError;

import java.util.List;

public interface SupplierServiceApplyService {

    /**
     * 分页查询清单
     * @param pageRequest
     * @return
     */
    CommonQueryPageResponse<SupplierServiceApply> page(CommonQueryPageRequest<SupplierServiceApplyReq> pageRequest);

    /**
     * 查询申请单详情
     * @param applyReq
     * @return
     */
    CommonResponse<SupplierServiceApply> detail(CommonRequest<SupplierServiceApplyReq> applyReq);

    /**
     * 保存更新服务清单申请单
     * @param request
     * @return
     */
    CommonResponse<List<SupplierServiceItemError>> save(CommonRequest<SupplierServiceApplySaveReq> request);

    /**
     * 保存更新服务清单申请单
     * @param request
     * @return
     */
    CommonResponse<Boolean> updateStatus(CommonRequest<SupplierServiceApplyReq> request);

    /**
     * 查询清单
     * @param request
     * @return
     */
    CommonResponse<List<SupplierServiceApply>> list(CommonRequest<SupplierServiceApplyReq> request);

//    /**
//     * 分页查询业务基点清单-未被打款工单使用
//     * @param pageRequest
//     * @return
//     */
//    CommonQueryPageResponse<SupplierServiceApply> pageUnUsedSupplierServiceApply(CommonQueryPageRequest<SupplierServiceApplyUnUsedByRemattanceReq> pageRequest);

    CommonResponse<Boolean> delete(CommonRequest<SupplierServiceApplyReq> reqCommonRequest);

}
