package com.roco.settle.api.Validator;


import com.roco.settle.api.annotation.Punctuation;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * 判断字符串是否包括标点符号
 * @author djt
 * @date 2020/5/26 22:52
 */
public class PunctuationValidator implements ConstraintValidator<Punctuation,String> {
    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value==null){
            return true;
        }
        String tmp=value.replaceAll("\\p{P}","");
        return tmp.length()==value.length();
    }
}
