package com.roco.settle.api.enums.policygiftdirect;

import lombok.Getter;

/**
 * @author Andrew
 * @create 2020/7/16 3:51 下午
 */
public enum PolicyGiftDirectMode {

    quota("quota", "按金额"),

    ratio("ratio", "按比例");

    @Getter
    private String code;

    @Getter
    private String label;



    PolicyGiftDirectMode(String code, String label) {
        this.code = code;
        this.label = label;
    }


    public static final String getLabelByCode(String code) {
        for (PolicyGiftDirectMode status : values()) {
            if (code != null && status.code.equals(code)) {
                return status.label;
            }
        }
        return code;
    }
}
