package com.roco.settle.api.service.enterprisesettle;

import com.roco.settle.api.entity.SettleEnterpriseServiceApplyItem;
import com.roco.settle.api.entity.enterprisesettle.SettleEnterpriseOilCardApply;
import com.roco.settle.api.entity.enterprisesettle.SettleEnterpriseOilCardApplyLog;
import com.roco.settle.api.request.base.CommonQueryPageRequest;
import com.roco.settle.api.request.base.CommonRequest;
import com.roco.settle.api.request.enterprisesettle.EnterpriseOilCardApplyQueryReq;
import com.roco.settle.api.request.enterprisesettle.EnterpriseOilCardOperateReq;
import com.roco.settle.api.request.enterprisesettle.EnterpriseOilCardPostApplyReq;
import com.roco.settle.api.request.enterprisesettle.PreviewUploadItemReq;
import com.roco.settle.api.response.base.CommonQueryPageResponse;
import com.roco.settle.api.response.base.CommonResponse;

/**
 * 业务基点->油卡结算申请 dubbo 服务
 * @author zhangmin
 * @create 2020/2/24 1:39 下午
 */
public interface SettleEnterpriseOilCardApplyService {

    /**
     * 分页查询 油卡结算申请单列表
     * @param request
     * @return
     */
     CommonQueryPageResponse<SettleEnterpriseOilCardApply> searchPage(CommonQueryPageRequest<EnterpriseOilCardApplyQueryReq> request);

    /**
     * 新增/修改 油卡结算申请
     */
    CommonResponse<String> saveUpdateApply(CommonRequest<EnterpriseOilCardPostApplyReq> request);

    /**
     * 操作申请单
     *
     * @param request
     * @return
     */
    CommonResponse<Boolean> operate(CommonRequest<EnterpriseOilCardOperateReq> request);

    /**
     * 获得申请详情
     * @param request
     * @return
     */
    CommonResponse<SettleEnterpriseOilCardApply> getDetailByApplyNo(CommonRequest<EnterpriseOilCardApplyQueryReq> request);


    /**
     * 查询清单列表
     * @param request
     * @return
     */
    CommonQueryPageResponse<SettleEnterpriseServiceApplyItem> findItemPageByApplyNo(CommonQueryPageRequest<EnterpriseOilCardApplyQueryReq> request);



    CommonQueryPageResponse<SettleEnterpriseOilCardApplyLog> findLogPageByApplyNo(CommonQueryPageRequest<EnterpriseOilCardApplyQueryReq> request);
}
