package com.roco.settle.api.entity.enterprise.transaction;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/7/2 14:50</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
@Table(name = "settle_enterprise_to_consumer_transaction_file")
public class SettleEnterpriseToConsumerTransactionFile implements Serializable {
    /**
     * 主键
     */
    @Id
    private Long id;

    /**
     * settle_enterprise_to_consumer_transaction.code
     */
    private String code;

    /**
     * 组序号
     */
    private Long ordernum;

    /**
     * 文件类型(PDF,PNG,JPG,JPEG)
     */
    private String fileType;

    /**
     * 路径url
     */
    private String fileUrl;

    /**
     * 附件名称
     */
    private String fileName;

    /**
     * 附件说明
     */
    private String remark;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    private Long createUser;

    /**
     *
     */
    private String createName;

    /**
     *
     */
    private String createUsertype;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private Long updateUser;

    /**
     *
     */
    private String updateName;

    /**
     *
     */
    private String updateUsertype;

    /**
     * 逻辑删除（0：未删除，1：已删除）
     */
    private Long deleted;
}