package com.roco.settle.api.entity.subject;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@Table(name = "settle_subject_supplier")
public class SettleSubjectSupplier implements Serializable {
    private Long id;
    private String code;
    private String subjectCode;
    private String supplierNo;
    /**
     * 创建人id
     */
    private Long createUser;

    /**
     * 创建人姓名
     */
    private String createName;

    /**
     * 创建人类型
     * */
    private String createUsertype;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 更新人id
     */
    private Long updateUser;

    /**
     * 更新人姓名
     */
    private String updateName;
    /**
     * 更新人类型
     * */

    private String updateUsertype;
    /**
     * 更新日期
     * */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

}
