package com.roco.settle.api.entity.supplier;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/5/1 15:12</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
@Table(name = "product_reference_supplier_deposit")
public class ProductReferenceSupplierDeposit implements Serializable {

    private Long id;

    /**
     * 平台商品编号
     */
    private String productCode;

    /**
     * 备付金账户
     */
    private String acctCode;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private Integer createUser;

    /**
     * 创建姓名
     */
    private String createName;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private Integer updateUser;

    /**
     * 更新人姓名
     */
    private String updateName;

}