package com.roco.settle.api.enums.enterprise.transaction;

public enum ToConsumerTransactionOperationEnum {
    /**
     * 创建
     */
    CREATE("创建"),
    /**
     * 编辑
     * */
    EDIT("编辑"),
    /**
     * 确认
     * */
    CONFIRM("确认"),
    /**
     * 作废
     * */
    INVALID("作废"),
    /**
     * 客户支付确认
     * */
    PROCESS("完成处理确认"),
    /**
     * 财务收款确认
     */
    SETTLE("完成结算确认");

    private String name;

    ToConsumerTransactionOperationEnum(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static String getName(Integer i) {
        if (i == null) {
            return "";
        }
        ToConsumerTransactionOperationEnum[] values = ToConsumerTransactionOperationEnum.values();
        return i >= 0 && i < values.length ? values[i].getName() : "" + i;
    }


    @Override
    public String toString() {
        return "Status{" +
                "name='" + name + '\'' +
                '}';
    }
}
