package com.roco.settle.api.request.productconfig;

import lombok.Data;

import javax.validation.constraints.Digits;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author djt
 * @date 2020/7/3 11:35
 */
@Data
public class SettleProductPackageItemSaveReq implements Serializable {
    /**
     * 套餐产品编码
     */
    private String packageCode;


    /**
     *销售主体可售产品编码
     */
    @NotBlank
    private String subjectProductCode;

    /**
     * 销售主体编码
     */
    @NotBlank
    private String subjectCode;

    /**
     * 可售产品编码
     */
    @Deprecated
//    @NotBlank
    private String productCode;

    /**
     * 可售产品简称
     */
    @NotBlank
    private String productSimpleName;

    /**
     * 类目编码
     */
    @NotBlank
    private String catalogCode;

    /**
     * 类目名称
     */
    private String productCatalogName;

    /**
     * 品牌编码
     */
    @NotBlank
    private String brandCode;


    /**
     * 品牌名称
     */
    @NotBlank
    private String brandName;

    /**
     * 面值
     */
    @NotNull
    private Integer facePrice;

    /**
     * 销售单价
     */
    @Digits(integer = 9,fraction = 3)
    @NotNull
    private BigDecimal sellingPrice;


    /**
     * 电子券张数
     */
    @NotNull
    private Integer count;


}
