package com.roco.settle.api.entity.agent;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.enums.StatusEnum;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author djt
 * @Description: 代理人标准套餐
 * @date 2020/10/30 11:29
 */
@Data
public class SettleStandardPackage implements Serializable {
    /**
     * id
     */
    @Id
    private Long id;

    /**
     * 套餐唯一编码（系统生成）
     */
    private String code;

    /**
     * 机构编码
     */
    private String enterpriseCode;

    /**
     * 机构代码
     */
    private String piccOrgCode;

    /**
     * 机构简称
     */
    private String enterpriseSimpleName;

    /**
     * 集成商编号(settle_biz_subject.code)
     */
    private String subjectCode;


    /**
     * 套餐名称
     */
    private String packageName;


    /**
     * 套餐亮点
     */
    private String packageHighLights;

    /**
     * 套餐总市场价
     */
    private BigDecimal faceValue;

    /**
     * 套餐总成本
     */
    private BigDecimal cost;

    /**
     * 套餐总采购价
     */
    private BigDecimal purchasingPrice;

    /**
     * 套餐产品数
     */
    private Integer productCount;

    /**
     * 产品款数
     */
    private Integer productTypeCount;

    /**
     * 套餐说明
     */
    private String remark;

    /**
     * 套餐状态
     */
    @Column(name = "status")
    private StatusEnum status;

    /**
     * 创建人id
     */
    private Integer createUser;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime createTime;

    /**
     *创建人名称
     */
    private String createName;

    /**
     * 更新人id
     */
    private Integer updateUser;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS, timezone = DateUtil.TIME_ZONE)
    private LocalDateTime updateTime;

    /**
     *更新人名称
     */
    private String updateName;
}
