package com.roco.settle.api.enums.policygiftdirect;

import lombok.Getter;

public enum PolicyGiftDirectOperation {
    submit("submit", "提交"),
    handle("handle", "处理"),
    settle("settle", "结算"),
    invalid("invalid", "作废")
    ;


    @Getter
    private String label;

    @Getter
    private String code;

    PolicyGiftDirectOperation(String code, String label) {
        this.code = code;
        this.label = label;
    }

    public static String getByCode(String code) {
        for (PolicyGiftDirectOperation v : values()) {
            if (v.code.equals(code)) {
                return v.getLabel();
            }
        }

        return null;
    }

}
