package com.roco.settle.api.request.productconfig;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Author zhanghongshan
 * @date 2020/11/4 2:08 下午
 */
@Data
public class EnterpriseProductReq implements Serializable {

    /**
     * 产品名称
     */
    private String keyword;
    /**
     * 车服产品类型
     */
    private String rocoProductType;
    /**
     * 市场价(最小)
     */
    private BigDecimal minMarketPrice;

    /**
     * 市场价(最大)
     */
    private BigDecimal maxMarketPrice;
    /**
     * 成本价(最大)
     */
    private BigDecimal maxCostPrice;

    /**
     * 成本价(最小)
     */
    private BigDecimal minCostPrice;

    /**
     * 市场排序 asc
     */
    private String marketPriceSort;

    /**
     * 成本价排序 desc
     */
    private String costPriceSort;

    /**
     * 预算
     */
    private BigDecimal budget;

    /**
     * 机构编码
     */
    private String enterpriseCode;

    /**
     * 产品code集合
     */
    private List<String> productCodes;

}
