package com.roco.settle.api.request.productconfig;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author djt
 * @date 2020/7/29 16:58
 */
@Data
public class SettleEnterpriseProductUpdateAmountReq implements Serializable {
    @NotBlank(message = "机构产品编号不能为空")
    private String code;



    /**
     * 拆单限额
     */
    @Min(1)
    @NotNull(message = "拆单金额上限")
    private Integer amountLimit;


    /**
     * 机构产品拆单金额说明
     */
    @Length(max = 100)
    private String amountLimitRemark;
}
