/*
 * Decompiled with CFR 0.152.
 */
package com.roco.settle.api.enums.enterprisetransfer;

import com.roco.settle.api.enums.enterprisetransfer.EnterpriseTransferStatus;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EnterpriseTransferOperate {
    SUBMIT(new EnterpriseTransferStatus[]{EnterpriseTransferStatus.NULL, EnterpriseTransferStatus.DRAFT}, EnterpriseTransferStatus.CONFIRMING),
    DELETE(new EnterpriseTransferStatus[]{EnterpriseTransferStatus.DRAFT}, EnterpriseTransferStatus.DELETED),
    CONFIRM(new EnterpriseTransferStatus[]{EnterpriseTransferStatus.CONFIRMING}, EnterpriseTransferStatus.CONFIRMED),
    RELATE(new EnterpriseTransferStatus[]{EnterpriseTransferStatus.CONFIRMED}, EnterpriseTransferStatus.RELATED),
    COMPLETE(new EnterpriseTransferStatus[]{EnterpriseTransferStatus.RELATED}, EnterpriseTransferStatus.COMPLETE),
    RELATE_BASE_POINT(new EnterpriseTransferStatus[]{EnterpriseTransferStatus.COMPLETE}, EnterpriseTransferStatus.RELATED_BASE_POINT),
    RELATE_BASE_POINT_ROLLBACK(new EnterpriseTransferStatus[]{EnterpriseTransferStatus.RELATED_BASE_POINT}, EnterpriseTransferStatus.COMPLETE),
    SETTLE(new EnterpriseTransferStatus[]{EnterpriseTransferStatus.RELATED_BASE_POINT}, EnterpriseTransferStatus.SETTLED),
    CANCEL(new EnterpriseTransferStatus[]{EnterpriseTransferStatus.CONFIRMING, EnterpriseTransferStatus.CONFIRMED}, EnterpriseTransferStatus.CANCEL),
    RELATED_ROLLBACK(new EnterpriseTransferStatus[]{EnterpriseTransferStatus.RELATED}, EnterpriseTransferStatus.CONFIRMED);

    private EnterpriseTransferStatus[] before;
    private EnterpriseTransferStatus after;

    public List<String> getBeforeList() {
        return Stream.of(this.before).map(Enum::name).collect(Collectors.toList());
    }

    private EnterpriseTransferOperate(EnterpriseTransferStatus[] before, EnterpriseTransferStatus after) {
        this.before = before;
        this.after = after;
    }

    public EnterpriseTransferStatus[] getBefore() {
        return this.before;
    }

    public EnterpriseTransferStatus getAfter() {
        return this.after;
    }
}

