package com.roco.settle.api.entity.capital;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.roco.settle.api.enums.SettleCapitalType;
import com.roco.settle.api.enums.capital.SettleAccountUseAmountItemTypeEnum;
import com.roco.settle.api.util.DateUtil;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/3/4 15:51</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
public class SettleAccountSettleAmountDetail implements Serializable {
    @Id
    private String accountCode;
    /**
     * 事项类型
     */
    @Column(name = "settle_type")
    private SettleCapitalType settleType;
    /**
     * 结算总金额
     */
    private BigDecimal settleAmount;

    /**
     * 结算总笔数
     */
    private Integer settleCnt;

    /**
     * 最后结算日期
     */
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD, timezone = DateUtil.TIME_ZONE)
    private LocalDate settleLastestDate;


}