package com.roco.settle.api.enums.order;


import lombok.Getter;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 供应商订单操作类型枚举
 * @author dongjuntong
 */
public enum OrderOperationTypeEnum {

    /**
     * 创建
     */
    CREATE(new OrderStatusEnum[]{OrderStatusEnum.EMPTY},OrderStatusEnum.WAIT_INVOICE),


    /**
     * 编辑发票
     */
    EDIT_INVOICE(new OrderStatusEnum[]{OrderStatusEnum.WAIT_INVOICE},OrderStatusEnum.WAIT_INVOICE),


    /**
     * 确认开票
     */
    CONFIRM_INVOICED(new OrderStatusEnum[]{OrderStatusEnum.WAIT_INVOICE},OrderStatusEnum.INVOICED),


    /**
     * 编辑寄送信息
     */
    EDIT_EXPRESSAGE(new OrderStatusEnum[]{OrderStatusEnum.INVOICED},OrderStatusEnum.INVOICED),



    /**
     * 财务确认收到发票
     */
    CONFIRM_RECEIVE(new OrderStatusEnum[]{OrderStatusEnum.INVOICED},OrderStatusEnum.RECEIVED),


    /**
     * 取消
     */
     INVALID(new OrderStatusEnum[]{OrderStatusEnum.INVOICED,OrderStatusEnum.WAIT_INVOICE},
            OrderStatusEnum.CANCEL);


     @Getter
     private OrderStatusEnum[] before;

    @Getter
    private OrderStatusEnum after;

    OrderOperationTypeEnum(OrderStatusEnum[] before,OrderStatusEnum after){
        this.before = before;
        this.after = after;
    }

    public List<String> getBefore(){
        return Stream.of(before).map(OrderStatusEnum::name).collect(Collectors.toList());
    }

    public String getAfter(){
        return this.after.name();
    }

}
