package com.roco.settle.api.request.expense.supplier;

import com.roco.settle.api.enums.ExpanseItemOnlineStatus;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;


/**
 * 供应商结算信息(SettleExpenseItemSupplier)实体类
 *
 * @author 兰倩
 * @since 2020-03-10 16:52:41
 */
@Data
public class SettleExpenseItemSupplierPageOneReq implements Serializable {
    /**
     *  供应商编号
     */
    @NotBlank(message = "供应商编号不可为空")
    private String supplierCode;
    /**
     * 费用项目编码
     */
    private String itemCode;
    /**
     * 项目简称
     */
    private String simpleName;
    /**
     * 产品分类*/
    private String catalogCode;
    /**
     * 项目性质
     * */
    private String projectNature;
    /**
     * 项目状态
     * */
    private Integer status;

    /**
     * 上下架状态
     * */
    private ExpanseItemOnlineStatus isOnline;
}