package com.roco.settle.api.request.order.payment;

import com.roco.settle.api.enums.order.payment.PaymentOrderOperationTypeEnum;
import com.roco.settle.api.enums.order.payment.PaymentOrderStatusEnum;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author dongjuntong
 */
@Data
public class SupplierPaymentApplyStatusReq implements Serializable {

    /**
     * 订单号
     */
    @NotBlank(message = "支付订单号不能为空")
    private String applyNo;

    /**
     * 操作
     */
    @NotNull(message = "操作类型不能为空")
    private PaymentOrderOperationTypeEnum orderOperationType;


    /**
     * 对应事项单号
     */
    @NotNull(message = "对应事项单号不能为空")
    private String settleOrderNo;

    /***
     * 对私转账单号
     */
    private String transferApplyNo;

}
