package com.roco.settle.api.request.privatetransfer;

import com.roco.settle.api.enums.enterprisetransfer.EnterpriseTransferOperate;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author hsf
 * @date 2020-03-01 04:37
 */
@Data
public class SettlePrivateApplyOperateReq implements Serializable {

    @NotBlank
    private String applyNo;

    @NotNull
    private EnterpriseTransferOperate operate;

    /**
     * 业务主体结算订单号，   关联的时候传入
     */
    private String settleOrderNo;


    /**
     * 业务基点结算单号
     */
    private String basePointSettleOrderNo;

    /**
     * 业务基点编码，   关联的时候传入
     */
    private String enterpriseCode;

    @Length(max = 200)
    private String desc;
}
