package com.rocogz.syy.equity.dto.equity.userCoupon;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.equity.EquityConstants;
import com.rocogz.syy.equity.entity.coupon.*;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * <dl>
 * <dd>Description: 用户券发放 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020-05-11 17:18:29</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class UserCouponAutoGrantDto {

    /**
     * 优惠券编号
     */
    private String code;

    /**
     * 优惠券名称
     */
    private String name;

    /**
     * 描述
     */
    private String description;

    /**
     * 优惠券类型：SERVICE：服务券，OIL_CASH：代金券
     */
    @NotNull(message = "优惠券类型" + EquityConstants.EMPTY_MESSAGE)
    private String typeCode;

    /**
     * 来源（如门店发放则传入门店编号，机构发放则传入机构编号）
     */
    @NotNull(message = "优惠券类型" + EquityConstants.EMPTY_MESSAGE)
    private String sourceCode;

    /**
     * 优惠券专区项目
     */
    private EquityCouponAreaProjectRel areaProjectRel;

    /**
     * 使用信息（指定可用专区标志、可用门店标志）
     */
    private EquityCouponUseInfo useInfo;

    /**
     * 投放信息
     */
    private EquityCouponLaunchInfo launchInfo;

    /**
     * 可用专区
     */
    private List<EquityCouponAvailableAreaRel> availableAreaRelList;

    /**
     * 可用门店
     */
    private List<EquityCouponStoreRel> storeRelList;

    /**
     * 活动编号(自动发券传入转赠编号)
     */
    @NotNull(message = "活动编号" + EquityConstants.EMPTY_MESSAGE)
    private String activityCode;

    /**
     * 发放模式（发放来源）
     */
    @NotNull(message = "发放模式" + EquityConstants.EMPTY_MESSAGE)
    private String grantModel;

    /**
     * 用户编号
     */
    private String userCode;

    /**
     * 手机号
     */
    @NotNull(message = "手机号" + EquityConstants.EMPTY_MESSAGE)
    private String mobile;

    /**
     * openId
     */
    private String openId;

    /**
     * 证件类型
     */
    private String idType;

    /**
     * 证件号码明文
     */
    private String idCardExplicit;

    /**
     * 保单编号
     */
    private String policyNo;

    /**
     * 车牌号
     */
    private String licenseNo;

    /**
     * 承保机构
     */
    private String policyOrgCode;

    /**
     * 发放张数
     */
    @NotNull(message = "发放张数" + EquityConstants.EMPTY_MESSAGE)
    private Integer quantity;

}
