package com.rocogz.entity.coupon;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * <dl>
 * <dd>Description: 优惠券信息表 entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2022-03-15 13:36:57</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_coupon_info")
public class EquityCouponInfo extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 优惠券编号
     */
    private String code;

    /**
     * 优惠券名称
     */
    private String name;

    /**
     * 优惠券类型，数据字典：COUPON_TYPE
     */
    private String type;

    /**
     * 折扣率
     */
    private BigDecimal discount;

    /**
     * 生效方式：POINT_DATE-指定日期，GENERATE-生成时生效
     */
    private String effectiveModel;

    /**
     * 生效值：yyyy-MM-dd 或 0
     */
    private String effectiveValue;

    /**
     * 失效方式：POINT_DATE-指定日期, LATER_DATE-生效后xx天失效
     */
    private String invalidModel;

    /**
     * 失效值:yyyy-MM-dd 或 大于0的整数
     */
    private String invalidValue;

    /**
     * 状态：DRAFT-草稿，PENDING-待上架，TO_LIST-已上架，DEL_LIST-已下架，CANCEL-作废，DELETE-已删除
     */
    private String status;

    /**
     * 删除标记：Y-已删除，N-未删除
     */
    private String deleteFlag;

    /**
     * 优惠券sku商品关系
     */
    @TableField(exist = false)
    private List<EquityCouponSkuGoodsRel> skuGoodsList;

}
