package com.rocogz.entity.coupon;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <dl>
 * <dd>Description: 优惠券兑换码生成记录表 entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2022-03-15 13:36:57</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("equity_coupon_redeem_record")
public class EquityCouponRedeemRecord extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 批次号
     */
    private String batchNo;

    /**
     * 优惠券编号
     */
    private String couponCode;

    /**
     * 优惠券名称
     */
    @TableField(exist = false)
    private String couponName;

    /**
     * 生成数量
     */
    private Integer quantity;

    /**
     * 状态:PENDING-待生成，IN_PROCESS-生成中，FAIL-失败，SOME_FAIL-部分失败，SUCCESS-完成，CANCEL-作废
     */
    private String status;
}
