package com.rocogz.entity.coupon;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 优惠券操作日志 Entity</dd>
 * <dd>Company: 广州大诚若谷信息科技有限公司</dd>
 * <dd>@date：2022-03-15 13:36:57</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
@TableName("equity_coupon_log")
public class EquityCouponLog {

    private static final long serialVersionUID=1L;

    /**
     * 优惠券编号
     */
    private String couponCode;

    /**
     * 操作类型：EDIT-编辑，TO_LIST-上架，DEL_LIST-下架，CANCEL-作废，DELETE-删除
     */
    private String type;

    /**
     * 操作前内容
     */
    private String beforRmk;

    /**
     * 操作后内容
     */
    private String afterRmk;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

}
