package com.rocogz.syy.infrastructure.dto.samsung.req;

import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * <dl>
 * <dd>Description: 短信发送 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020-11-04 10:38:42</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
public class SmsSendParamDto{

    /**
     * 渠道
     */
    private String chlcd;

    /**
     * 手机号
     */
    @NotNull
    private String mobile;

    /**
     * 短信类型：
     * H-修改手机号码（您正在尝试修改手机号码，请勿泄露给他人使用。）
     * S-绑定会员手机号码（您正在尝试绑定手机号码，请勿泄露给他人使用。 ）
     * U-积分使用短信验证码（您正在尝试使用三星积分，请勿泄露给他人使用。）
     * Z-简易注册会员（请勿泄露给他人使用。）
     */
    @NotNull
    private String smsType;

    /**
     * 积分使用渠道
     */
    private String useChannel;

    /**
     * 会员姓名
     */
    private String memberName;

    /**
     * 三星账号密码
     */
    private String accountPassword;

    /**
     * 积分到期日期
     */
    private String pointEndDate;

    /**
     * 积分使用额度
     */
    private String useAmount;

    /**
     * 即将失效积分
     */
    private String expireAmount;

}
