package com.rocogz.syy.infrastructure.dto.charge.req;

import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/12/31 上午11:12</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@Getter
@Setter
@Accessors(chain = true)
public class ChargeRequestDto {

    /**
     * 带充值的账号
     */
    @NotBlank
    private String accountVal;

    /**
     * 业务分类代码(CYHF）
     */
    @NotBlank
    private String bizType;

    /**
     * 充值数量（为空默认为1）
     */
    private Integer buyNum;

    /**
     * 回调地址
     */
    private String callbackAddress;

    /**
     * 不大于32位的唯一订单号
     */
    @NotBlank
    private String orderNo;

    /**
     * 产品ID
     */
    @NotBlank
    private String productId;
}
